//
// Created by 76538 on 2/3/2021.
//

// xyx: may need to test in the future; the current implementation
//      looks suspicious.


#include "union_find.h"

using namespace std;


Tree_node::Tree_node(int X) : parent(this) {
    this->value = X;
//    this->parent = this;
    this->rank = 0;
    this->children = 0;
    this->marked = false;
}

Tree_node::~Tree_node() {
    this->parent = nullptr;
}

Tree_node* Make_set (int value){
//    Tree_node X(value);
//    return X;
    return new Tree_node(value);
}

Tree_node* Union (Tree_node* x, Tree_node* y){
    return Link(Find_set(x), Find_set(y));
}

Tree_node* Link (Tree_node* x, Tree_node* y){
    if (x->rank > y->rank) {
        y->parent = x;
        x->children += (y->children + 1);
        return x;
    }
    else {
        x->parent = y;
        y->children += (x->children + 1);
        if (x->rank == y->rank) {
            y->rank += 1;
        }
        return y;
    }
}

Tree_node* Find_set (Tree_node* x) {
    Tree_node* parent = x->parent;
    if (parent != x) {
        parent = Recursive_find_set(x->parent, x->children);
        x->parent = parent;
    }
    if (x->marked == true && x->children == 0) {
        Free(x);
    }
    return parent;
}

Tree_node* Recursive_find_set (Tree_node* x, int c) {
    Tree_node* parent = x->parent;
    if (x != parent) {
        parent = Recursive_find_set(x->parent, x->children);
        x->parent = parent;
        x->children -= c;
        if (x->marked == true && x->children == 0) {
            Free(x);
        }
    }
    return parent;
}

void Delete (Tree_node* x) {
    if (x != x->parent) {
        Clean(x->parent);
    }
    if (x->children != 0){
        x->marked = true;
    } else {
        Free(x);
    }
}

void Clean (Tree_node* x) {
    x->children -= 1;
    if (x != x->parent) {
        Clean(x->parent);
    }
    if (x->marked == true && x->children == 0) {
        Free(x);
    }
}

void Free (Tree_node* x) {
    cout << "Node" << x->value << " has been deleted" << endl;
}